/**
 * 
 */
package gov.va.med.mhv.usermgmt.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.data.model.Activity;

/**
 * @author vhaislegberb
 *
 */
@Component
public class ActivityDTOConverter implements Converter<ActivityDTO, Activity> {
	
	private final static int DETAIL_VALUE_MAX_LENGTH = 255;

	@Override
	public Activity convert(ActivityDTO source) {
		Activity destination = new Activity();
		destination.setAction(source.getAction());
		destination.setActivityId(source.getActivityId());
		destination.setActivityType(source.getActivityType());
		destination.setCompletionTime(source.getCompletionTime());
		if(source.getDetailValue() != null) {
			destination.setDetailValue(abbreviateString(source.getDetailValue(),DETAIL_VALUE_MAX_LENGTH));
		}
		destination.setPerformerType(source.getPerformerType());
		destination.setStatus(source.getStatus());
		destination.setUserProfileId(source.getUserProfileId());
		return destination;
	}
	
	private static String abbreviateString(String input, int maxLength) {
	    if (input.length() <= maxLength) 
	        return input;
	    else 
	        return input.substring(0, maxLength-2) + "..";
	}

}
